/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class Tree extends Composite {
	TreeItem[] items;
	int itemCount;

public Tree (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addSelectionListener (SelectionListener listener) {
}

public void addTreeListener (TreeListener listener) {
}

static int checkStyle (int style) {
	/*
	* To be compatible with Windows, force the H_SCROLL
	* and V_SCROLL style bits.  On Windows, it is not
	* possible to create a tree without scroll bars.
	*/
	style |= SWT.H_SCROLL | SWT.V_SCROLL;
	return checkBits (style, SWT.SINGLE, SWT.MULTI, 0, 0, 0, 0);
}

protected void checkSubclass () {
}

public void clear (int index, boolean all) {
}

public void clearAll (boolean all) {
}

public Point computeSize (int wHint, int hHint, boolean changed) {
//TODO make use of changed
	Rectangle rectangle = getNativeBounds();
	Rectangle trim = computeTrim (rectangle.x, rectangle.y, rectangle.width, rectangle.height);
	if (wHint != SWT.DEFAULT) trim.width = wHint;
	if (hHint != SWT.DEFAULT) trim.height = hHint;
	return new Point (trim.width, trim.height);
}

public void createItem(Widget parent, TreeItem treeItem, int style, int index) {
	itemCount++;
	if (itemCount == items.length) {
		TreeItem [] newItems = new TreeItem [items.length + 4];
		System.arraycopy (items, 0, newItems, 0, items.length);
		items = newItems;
	}
	items[itemCount] = treeItem;
	treeItem._createItem(parent, style, index, itemCount);
}

void createWidget (Display display, Widget parent, int style, int index) {
	super.createWidget (display, parent, style, index);
	items = new TreeItem [4];
	itemCount = -1;
}

public void deselectAll () {
}

public int getGridLineWidth () {
	return 0;
}

public int getHeaderHeight () {
	return 0;
}

public boolean getHeaderVisible () {
	return false;
}

public TreeColumn getColumn (int index) {
	return null;
}

public int getColumnCount () {
	return 0;
}

public int[] getColumnOrder () {
	return null;
}

public TreeColumn[] getColumns () {
	return null;
}

public TreeItem getItem (int index) {
	checkWidget ();
	if (index < 0 || index>=getItemCount()) error (SWT.ERROR_INVALID_RANGE);
//	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	return items[_getItem (index)]; 
}

public TreeItem getItem (Point point) {
	return null;
}

public int getItemCount () {
	return _getItemCount ();
}

public int getItemHeight () {
	return 0;
}

public TreeItem[] getItems () {
	checkWidget();
	TreeItem [] items = new TreeItem[getItemCount()];
	for (int i=0; i<getItemCount(); i++){
		items[i] = getItem(i);
	}
	return items;
}

public boolean getLinesVisible () {
	return false;
}

public TreeItem getParentItem () {
	return null;
}

public TreeItem[] getSelection () {
	return null;
}

public int getSelectionCount () {
	return 0;
}

public TreeColumn getSortColumn () {
	return null;
}

public int getSortDirection () {
	return 0;
}

public TreeItem getTopItem () {
	return null;
}


void hookEvents () {
	super.hookEvents();
	_hookEvents("onclick",	SWT.Selection);
//TODO Find the corresponding events	
//	_hookEvents("onclick",	SWT.DefaultSelection);
//	_hookEvents("onclick",	SWT.Collapse);
//	_hookEvents("onclick",	SWT.Expand);
//	_hookEvents("onclick",	SWT.SetData);
//	_hookEvents("onclick",	SWT.MeasureItem);
//	_hookEvents("onclick",	SWT.EraseItem);
//	_hookEvents("onclick",	SWT.PaintItem);
}



public int indexOf (TreeColumn column) {
	return 0;
}

public int indexOf (TreeItem item) {
	return 0;
}

public void removeAll () {
}

public void removeSelectionListener (SelectionListener listener) {
}

public void removeTreeListener (TreeListener listener) {
}

public void setInsertMark (TreeItem item, boolean before) {
}

public void setItemCount (int count) {
}

public void setLinesVisible (boolean show) {
}

public void selectAll () {
}

public void setColumnOrder (int[] order) {
}

public void setFont (Font font) {
}

public void setHeaderVisible (boolean show) {
}

public void setRedraw (boolean redraw) {
}

public void setSelection (TreeItem item) {
}

public void setSelection (TreeItem[] items) {
}

public void setSortColumn (TreeColumn column) {
}

public void setSortDirection (int direction) {
}

public void setTopItem (TreeItem item) {
}

public void showColumn (TreeColumn column) {
}

public void showItem (TreeItem item) {
}

public void showSelection () {
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.Tree"]){
		$wnd.dojo._hasResource["org.eclipse.swt.Tree"] = true;
		$wnd.dojo.provide("org.eclipse.swt.Tree");
		
		$wnd.dojo.require("dijit.Tree");
		$wnd.dojo.require("dojo.data.ItemFileReadStore");
	
		$wnd.dojo.declare("org.eclipse.swt.Tree", $wnd.eval("[dijit.Tree, dijit._Container]"), {
			border: "",
			constructor: function(){
				this.model = new $wnd.dijit.tree.ForestStoreModel({
					store: new $wnd.dojo.data.ItemFileReadStore({data: {items: []}})
				});
			},
			_load: function(){},
			addChild: function (child, index){
	        	this.inherited("addChild", arguments);
	        	$wnd.dojo.forEach(this.getChildren(), function(child){
					$wnd.dojo.toggleClass(child.domNode, "dijitTreeIsLast", !child.getNextSibling());
				});
	        },
	        getNativeBounds: function(){
				var dim = $wnd.swt.getNativeBounds(this.domNode);
//FIXME temp fix for IE margins				
				if ($wnd.dojo.isIE) {dim.w+=42; dim.h+=5;}
				return dim;
			},
	        postCreate: function(){
				this.inherited("postCreate", arguments);
	        	$wnd.swt.setCssStyle(this.domNode, {
					border: this.border,
					zIndex: 1
	        	});
			},
			resize: function(dim){}
		});
	}
	var params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var self = new $wnd.org.eclipse.swt.Tree(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also
		$wnd.console.log(e);
	}
}-*/;

native int _getItem (int index) /*-{
	return this.@org.eclipse.swt.widgets.Widget::jsObject.getChildren()[index].indexInArray;  
}-*/;

native int _getItemCount () /*-{
	return this.@org.eclipse.swt.widgets.Widget::jsObject.getChildren().length;
}-*/;

}
